import ServerMgr from "./ServerMgr";
import TokenMgr from "./TokenMgr";
import FrozenIPMgr from "./FrozenIPMgr";
import FrozenMacMgr from "./FrozenMacMgr";
import DB from "../utils/DB";
import Charge from "../utils/Charge";
import Http from "../utils/Http";
// 网络请求
import bodyParser from "body-parser";
import express from "express";
import { Express, Request, Response } from "express";
import DataUtil from "../gear/SKDataUtil";
import SKDataUtil from "../gear/SKDataUtil";
import SKLogger from "../gear/SKLogger";
import GameConf from "../../conf/GameConf";
import GameUtil from "../core/GameUtil";
import { MsgCode } from "../role/EEnum";
import GoodsMgr from "../item/GoodsMgr";
import GTimer from "../common/GTimer";
import SKCxfUtil from "../gear/SKCxfUtil";
import Ofuda from "../object/Ofuda";

export default class HttpGate {
    static shared = new HttpGate();
    //账号格式6-22位字母数字
    accountPattern: any  = /^[a-zA-Z0-9]{6,22}$/;
    app: Express;
    AccountRegisterList: any = {};
    createList: any = {};
    chargeActivityState: any = {}; // 充值活动是否开启的状态 
    payUserKey: string = "";
    reportKey: string[] = [];

    constructor() {
        this.app = express();
        this.app.use(function (req: Request, res: Response, next: any) {
            res.header("Access-Control-Allow-Origin", "*");
            res.header("Access-Control-Expose-Headers", "'Content-Type,Access-Control-Allow-Headers,Authorization,X-Requested-With");
            res.header("Access-Control-Allow-Methods", "PUT,POST,GET,DELETE,OPTIONS");
            res.header("X-Powered-By", ' 3.2.1');
            res.header("Content-Type", "application/json;charset=utf-8");
            next();
        });
        this.app.use(bodyParser.json({ limit: "1mb" }));
        this.app.use(bodyParser.urlencoded({ limit: "1mb", extended: true }));
    }

    registerServer(req: any, res: any) {
        let server_id = req.query.server_id;
        let server_name = req.query.server_name;
        let outer_ip = req.query.outer_ip;
        let socket_port = req.query.socket_port;
        let http_port = req.query.http_port;
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let ret = ServerMgr.shared.serverReg(server_id, server_name, outer_ip, socket_port, http_port);
        SKLogger.info(`游戏服注册:[${server_id}:${server_name}]外网地址[${outer_ip}:${socket_port}]HTTP端口[${http_port}]`);
        Http.reply(res, {
            result: ret ? MsgCode.SUCCESS : MsgCode.FAILED,
            tokens: TokenMgr.shared.getAllToken(),
        });
    };

    pingServer(req: any, res: any) {
        let id = req.query.id;
        let n = req.query.num;
        let ret = ServerMgr.shared.serverPing(id, n);
        Http.reply(res, {
            result: ret,
        });
    };

    /*
    * 根据serverid获取server列表
    * @param serverid 服务器id
    */
    getServerListByServerid(serverid: number) {
        let server_list = [];
        let servers = ServerMgr.shared.getServerList();
        if (serverid == 0) {
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        }
        else {
            let server = ServerMgr.shared.getServer(serverid);
            if (server) {
                server_list.push(server);
            }
        }
        return server_list;
    }
    // 通过连接 获取客户端ip
    getClientIP(req: any, res: any): string {
        var ip = req.headers['x-forwarded-for'] ||
            req.ip ||
            req.connection.remoteAddress ||
            req.socket.remoteAddress ||
            req.connection.socket.remoteAddress || '';
        ip = ip.replace(/::ffff:/, '');
        if (ip.split(',').length > 0) {
            ip = ip.split(',')[0];
        }
        return ip;
    }
    // 注册请求
    register(req: any, res: any) {
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.NETWORK_ERROR,
                msg: "游戏关服维护中,请稍候注册!"
            });
            return;
        }
        let account = req.query.account.trim();
        let password = req.query.password.trim();
        let invitecode = req.query.invitecode.trim();
        invitecode = invitecode.replace(" ", "*")

        if (!this.accountPattern.test(account)){
            Http.reply(res, {
                code: MsgCode.OPERATION_ERROR,
                msg: `账号请不要输入特殊字符`
            });
            return;
        }

        if (this.AccountRegisterList[account]) {
            Http.reply(res, {
                code: MsgCode.INVITE_CODE_ERR,
                msg: `已注册`
            });
            return;
        }
        let ip = this.getClientIP(req, res);
        if (!FrozenIPMgr.shared.checkIP(ip)) {
            Http.reply(res, {
                code: MsgCode.INVITE_CODE_ERR,
                msg: `禁止注册`
            });
            return;
        }
        // 检查邀请码
        DB.isCodeEnable(invitecode,(code: number,msg: String) =>{
            if (code == MsgCode.SUCCESS){
                let nowtime = Date.now();
                this.AccountRegisterList[account] = {
                    account: account,
                    password: password,
                    invitecode: invitecode,
                    reqtime: nowtime,
                    ip: ip,
                }
                DB.accountRegister({
                    account: account,
                    password: password,
                    invitecode: invitecode
                }, (code: number, msg: string) => {
                    delete this.AccountRegisterList[account];
                    Http.reply(res, {
                        code: code,
                        msg: msg
                    });
                });
            }else {
                Http.reply(res, {
                    code: MsgCode.INVITE_CODE_ERR,
                    msg: `无效的邀请码`
                });
                return;
            }
        })
    }

    // 玩家登录
    login(req: any, res: any) {
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.NETWORK_ERROR,
                msg: "游戏关服维护中,请稍候登录!"
            });
            return;
        }
        let account = req.query.account;
        let password = req.query.password;
        let version = req.query.version;
        let mac = req.query.mac;
        let ip = this.getClientIP(req, res);
        if (!FrozenIPMgr.shared.checkIP(ip)) {
            console.warn(`登录:帐号[${account}]登录失败:被禁IP[${ip}]`);
            Http.reply(res, {
                code: MsgCode.FORZEN_IP,
                msg: "您的帐号IP被冰结!"
            });
            return;
        }
        if (!FrozenMacMgr.shared.checkMAC(mac)) {
            console.warn(`登录:帐号[${account}]登录失败:被禁MAC[${mac}]`);
            Http.reply(res, {
                code: MsgCode.FORZEN_MAC,
                msg: "您的帐号MAC被冰结!"
            });
            return;
        }
/*         if (DataUtil.checkVersion(version, GameConf.login_version) < 0) {
            let info = `您的游戏端版本号${version}过低,为更好的游戏体验请退出游戏自动升级!`;
            SKLogger.warn(`登录:帐号[${account}]登录失败,版本号[${version}]过低!`);
            Http.reply(res, {
                code: MsgCode.LOGIN_LOW_VERSION,
                msg: info
            });
            return;
        } */
        SKLogger.debug(`登录:玩家[${account}]读表登录...`);
        DB.accountLogin({
            account: account,
            password: password,
            ip: ip,
            mac: mac,
        }, (code: number, msg: string, data: any) => {
            let result: any = {
                code: code,
                msg: msg
            };
            if (code == MsgCode.SUCCESS) {
                result.accountid = data.accountid;
                result.account = data.account;
                if (data.state == 1) {
                    SKLogger.warn(`登录::玩家[${account}]登录失败:被加入黑名单`);
                    result.code = MsgCode.NETWORK_ERROR;
                    result.msg = "被加入黑名单";
                }
                if (data.state == 0) {
                    let token = TokenMgr.shared.makeSecret(data.accountid);
                    result.token = token;
                    SKLogger.debug(`登录:玩家[${account}]读表登录成功[${token}]`);
                } else {
                    SKLogger.debug(`登录:玩家[${account}]读表登录状态错误[${data.state}]`);
                }
            } else {
                SKLogger.debug(`玩家[${account}]读表登录失败[${code}]`);
            }
            Http.reply(res, result);
        });
    }

    /*
     * 修改密码
     */
    changePassword(req: any, res: any) {
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.NETWORK_ERROR,
                msg: "游戏关服维护中,请稍候修改密码!"
            });
            return;
        }
        let account = req.query.account;
        let safecode = req.query.safecode;
        let password = req.query.password;
        let verify = true;
        if (safecode.length < 4 || safecode.length > 12 || !/^[a-zA-Z0-9]*$/.test(safecode)) {
            verify = false;
        }
        if (account.length < 6 || account.length > 20 || !/^[a-zA-Z0-9]*$/.test(account) || /^[0-9]*$/.test(account)) {
            verify = false;
        }
        if (password.length < 6 || password.length > 20 || !/^[a-zA-Z0-9]*$/.test(password)) {
            verify = false;
        }
        if (!verify) {
            Http.reply(res, { errcode: MsgCode.FAILED });
        }
        else {
            DB.accountChangePassword({
                account: account,
                safecode: safecode,
                password: password,
            }, (ret: any) => {
                Http.reply(res, { errcode: ret });
            });
        }
    }
    // 服务器及角色列表
    serList(req: any, res: any) {
        let accountid = req.query.accountid;
        // 设置推荐服
		if(accountid == undefined || !/^\d+$/.test(accountid)){
            Http.reply(res, {result: MsgCode.LOGIN_NO_TOKEN});
            return;
        }
        let guideList = ServerMgr.shared.getGuideList();
        SKLogger.debug(`玩家[${accountid}]读取服务器列表...`);
        let guides: any = {};
        for (let sid in guideList) {
            if (guideList.hasOwnProperty(sid)) {
                let server = guideList[sid];
                let item = {
                    id: server.sid,
                    servername: server.name,
                    ip: 0, //net_ip,
                    port: 0, //net_port,
                };
                guides[item.id] = item;
            }
        }
        let serverList = ServerMgr.shared.getServerList();
        let servers: any = {};
        for (let sid in serverList) {
            if (serverList.hasOwnProperty(sid)) {
                let server = serverList[sid];
                let item = {
                    id: server.sid,
                    servername: server.name,
                    ip: 0, //net_ip,
                    port: 0, //net_port,
                };
                servers[item.id] = item;
            }
        }
        let retdata: any = {
            guideList: guides,
            serverList: servers,
            roleList: [],
        };
        DB.getServerListByAccountId(accountid, (code: any, dbdata: any) => {
            if (code == MsgCode.SUCCESS) {
                for (let data of dbdata) {
                    let rinfo = {
                        accountid: data.accountid,
                        roleid: data.roleid,
                        name: data.name,
                        race: data.race,
                        sex: data.sex,
                        level: data.level,
                        serverid: data.serverid,
                        resid: data.resid,
                        mapid: data.mapid,
                    };
                    retdata.roleList.push(rinfo);
                }
                retdata.result = code;
            }
            SKLogger.debug(`玩家[${accountid}]读取服务器列表完成[${code}]`);
            Http.reply(res, retdata);
        });
    }

    // 创建角色
    createRole(req: any, res: any) {
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.NETWORK_ERROR,
                msg: "游戏关服维护中,请稍候注册角色!"
            });
            return;
        }
        let rag = /^[\u4e00-\u9fa5]{3,5}$/;
        let name = req.query.name;
        let race = req.query.race;
        let sex = req.query.sex;
        let accountid = req.query.accountid;
        let serverid = req.query.serverid;
        let resid = req.query.resid;
        let namelimit = ['江湖', '如来', '第一人'];

        if (rag.test(name) == false) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `名字不符合规则(3~5个中文字符)`,
                roleid: 0,
            });
            SKLogger.warn(`创建角色:[${accountid}:${name}]角色名非法!`);
            return;
        }
        for (let ln of namelimit) {
            if (name.indexOf(ln) != -1) {
                Http.reply(res, {
                    code: MsgCode.FAILED,
                    msg: `非法角色名称`,
                    roleid: 0,
                });
                SKLogger.warn(`创建角色:[${accountid}:${name}]角色名非法!`);
                return;
            }
        }
        let checkname = GameUtil.checkLimitWord(name);
        if (!checkname) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `角色名称已存在`,
                roleid: 0,
            });
            SKLogger.warn(`创建角色:[${accountid}:${name}]角色名不合要求!`);
            return;
        }
       let key = SKDataUtil.rolePrimaryKey(8);
        let roleData = {
            name: name,
            roleId: (10000000 + Number(accountid)).toString(),
            race: race,
            sex: sex,
            accountid: accountid,
            serverid: serverid,
            resid: resid,
            daySignIn: GameUtil.getDaySignIn(),
            dial_num: 1,
            dial_count: 0,
            dial_date: GTimer.getYearMonthDay(),
            ai_flag: 0,
        };
        let nowtime = Date.now();
        let createTime = this.createList[accountid * 10000 + serverid];
        if (createTime != null && (nowtime - createTime) < 10 * 1000) {
            res.end();
            SKLogger.warn(`创建角色:[${accountid}:${name}]超时返回!`);
            return;
        }
        this.createList[accountid * 10000 + serverid] = nowtime;
        DB.insertRole(roleData, (code: any, roleId: any) => {
            delete this.createList[accountid * 10000 + serverid];
            Http.reply(res, {
                code: code,
                msg: `创建角色${code == MsgCode.SUCCESS ? "成功" : "失败"}`,
                roleid: roleId,
            });
            SKCxfUtil.getCxfRegisterPlayer({playerAccountId: accountid, playerZone: serverid, playerRoleId: roleId, playerRoleName: name});
            SKLogger.debug(`创建角色:[${accountid}:${name}]${code == 0 ? "成功" : "失败"}`);
        });
    }
    /**
     *  进入某个服务器
     *  req 
     *      accountid
     *      serverid
     *  res 
     *      result: errorcode
     *      ip:
     *      port
     */
    // 登录游戏服务器
    toServer(req: any, res: any) {
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: "游戏关服维护中,请稍候进入!"
            });
            return;
        }
        let accountId = req.query.accountId;
        let roleId = req.query.roleId;
        let serverId = req.query.serverId;
        let token = TokenMgr.shared.getSecretByAccountId(accountId);
        if (token == null) {
            console.warn(`玩家[${roleId}]登录Token不存在!`);
            Http.reply(res, {
                code: MsgCode.LOGIN_NO_TOKEN,
                msg: `你需要重新登录获得Token!`,
            });
        } else {
            let server = ServerMgr.shared.getServer(serverId);
            if (server == null) {
                SKLogger.warn(`玩家[${roleId}]登录服务器[${serverId}]不存在!`);
                Http.reply(res, {
                    code: MsgCode.LOGIN_NO_SERVER,
                    result: `登录服务器不存在,请稍候重试!`
                });
            } else {
                Http.sendget(server.net_ip, server.http_port, "/login_token", {
                    accountid: accountId,
                    roleid: roleId,
                    token: token,
                }, (success: boolean, data: any) => {
                    SKLogger.debug(`玩家[${roleId}]登录服务器[${server.net_ip}:${server.net_port}]code[${success}]!`);
                    Http.reply(res, {
                        code: success ? MsgCode.SUCCESS : MsgCode.FAILED,
                        ip: GameConf.outer_ip,
                        port: server.net_port,
                        token: token,
                    });
                });
            }
        }
    }

    /*
     * 充值活动(双倍活动)
     * @param req.query.start 开始时间
     * @param req.query.end 结束时间
     * @param req.query.serverid 服务器id 0为所有服务器
     */
    setChargeActivity(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let cur_tm = (new Date()).getTime();
        Http.reply(res, {
            errcode: (cur_tm < req.query.end) ? 0 : 1,
        });
        if (cur_tm >= req.query.end) {
            return;
        }
        let send_data: any = {
            start: parseInt(req.query.start),
            end: parseInt(req.query.end),
        };
        let callback = (ret: any, data: any) => { };
        let serverid = req.query.serverid;
        let server_list = this.getServerListByServerid(serverid);
        for (let server of server_list) {
            Http.sendget(
                server.net_ip,
                server.http_port,
                '/set_charge_activity',
                send_data,
                callback
            );
            this.chargeActivityState[server.sid] = {
                state: 0,
                start: req.query.start,
                end: req.query.end,
            };
        }
    }

    /*
     * 打开充值活动
     */
    openChargeActivity(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        Http.reply(res, {
            errcode: 0,
        });
        let ip = this.getClientIP(req, res);
        let serverid = req.query.serverid;
        if (serverid == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                if (this.chargeActivityState[key]) {
                    this.chargeActivityState[key].state = 1;
                }
            }
        }
        else {
            if (this.chargeActivityState[serverid]) {
                this.chargeActivityState[serverid].state = 1;
            }
        }
    }

    /*
     * 关闭充值活动
     * @param req.query.serverid 服务器id 0为所有服务器
     */
    closeChargeActivity(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        Http.reply(res, {
            errcode: 0,
        });
        let serverid = req.query.serverid;
        if (serverid == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                if (this.chargeActivityState[key]) {
                    this.chargeActivityState[key].state = 0;
                }
            }
        }
        else {
            if (this.chargeActivityState[serverid]) {
                this.chargeActivityState[serverid].state = 0;
            }
        }
        let server_list = this.getServerListByServerid(serverid);
        let callback = (ret: any, data: any) => { };
        for (let server of server_list) {
            Http.sendget(
                server.net_ip,
                server.http_port,
                '/closeChargeActivity',
                {},
                callback
            );
        }
    }

    /*
     * 查询充值活动
     */
    getChargeActivity(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        Http.reply(res, this.chargeActivityState);
    }

    /*
     * 充值
     */
    charge(req: any, res: any) {
        let roleid = req.query.roleid;
        //关闭充值
        if (!GameConf.payEnabled) {
            Http.reply(res, { code: MsgCode.PAY_DISABLED });
            return;
        }
        let goodsid = req.query.goodsid;
        let goodscount = 1;
        let pay_bankcode = parseInt(req.query.pay_bankcode);
        let money = parseInt(req.query.money);
		let type = parseInt(req.query.type);
        Charge.shared.createOrder(roleid, goodsid, goodscount, pay_bankcode, money, this.chargeActivityState, type, (ret: any, data: any) => {
            let send_data = {
                code: (ret) ? MsgCode.SUCCESS : MsgCode.FAILED,
                data: data,
            };
            Http.reply(res, send_data);
        });
    }
    // 代理充值
    agentCharge(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let roleid = req.query.role_id;
        let charge_id = parseInt(req.query.charge_id);
        if (!charge_id) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: '代理充值,无效的charge_id参数',
            });
        }
        let count = parseInt(req.query.count);
        if (!count) {
            count = 1;
        }
        Charge.shared.agentCharge(roleid, charge_id, count, this.chargeActivityState, (code: number, msg: string) => {
            Http.reply(res, {
                code: code,
                msg: msg,
            });
        });
    }
    // 充值返回
    payReturn(req: any, res: any) {
        Charge.shared.pay_return(req, res);
    }
	
	// 充值返回
    payNotify(req: any, res: any) {
        Charge.shared.pay_notify(req, res);
    }

    // 获得公告
    async getComment(req: any, res: any) {
        let serverId = 0;
        if (req.query.serverId) {
            serverId = req.query.serverId;
        }
        DB.getComment(serverId, (code, data) => {

            Http.reply(res, {
                code: MsgCode.SUCCESS,
                title: data.title,
                text: data.text,
            });
        })
    }
	
    // 设置公告
    setComment(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let serverId = req.query.serverId;
        if (!serverId) {
            serverId = 0;
        }
        let text: string = req.query.text;
        if (text.length < 1) {
            return;
        }
        text = decodeURI(text);
        // SKRedisUtil.setExpireValue(`comment_${serverId}`, text, 3 * 60);
        DB.setComment(serverId, text, (code: number) => {
            Http.reply(res, {
                code: code,
            });
        })
    }

    sysNotice(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let text = String(req.query.text);
        if (!text || text.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: "通知文本不能为空"
            });
            return;
            return;
        }
        let type = req.query.type; // 1 走马灯 2 聊天框 3 走马灯 + 聊天框
        let serverid = req.query.server_id; // 0 则全服公告
        let times = req.query.times; // -1 则永久公告 需入库
        if (!times || isNaN(times)) {
            times = 1;
        }
        let interval = req.query.interval; // 单位 秒
        text = decodeURIComponent(text);
        let server_list = [];
        if (serverid == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        } else {
            let server = ServerMgr.shared.getServer(serverid);
            if (server)
                server_list.push(server);
        }
        if (server_list.length == 0) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: "发送系统通知找不到服务器"
            });
            return;
        }
        Http.reply(res, {
            code: MsgCode.SUCCESS,
            msg: `发送系统通知:${text}到${serverid}成功!`
        });
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, '/sys_notice', {
                text: text,
                type: type,
                times: times,
                interval: interval,
            }, (success: boolean) => {
            });
        }
        if (times == -1) {
            DB.addScrollNotice(serverid, type, text);
        }
    }

    onlineNum(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let numinfo = [];
        let list = ServerMgr.shared.getServerList();
        for (const sid in list) {
            if (list.hasOwnProperty(sid)) {
                const server = list[sid];
                let n = server.getPlayerNum();
                numinfo.push({
                    id: server.sid,
                    name: server.name,
                    num: n,
                });
            }
        }
        Http.reply(res, {
            info: SKDataUtil.toJson(numinfo, "[]"),
        });
    }

    notSpeak(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let roleid = req.query.role_id;
        let serverid = req.query.server_id;
        let pServer = ServerMgr.shared.getServer(serverid);
        if (!pServer) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `玩家所在服务器不存在:${serverid}`
            });
            return;
        }
        Http.sendget(pServer.net_ip, pServer.http_port, '/can_speak', {
            roleid: roleid,
            state: 1
        }, (ret: any) => {

        });
        Http.reply(res, {
            code: MsgCode.SUCCESS,
            msg: `${roleid}所在服务器${serverid}禁言成功`,
        });
    }

    canSpeak(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let roleid = req.query.role_id;
        let serverid = req.query.server_id;
        let pServer = ServerMgr.shared.getServer(serverid);
        if (null == pServer)
            return;
        Http.sendget(pServer.net_ip, pServer.http_port, '/can_speak', {
            roleid: roleid,
            state: 0
        }, (ret: any) => { });
        Http.reply(res, {
            code: MsgCode.SUCCESS,
            msg: `${roleid}所在服务器${serverid}解除禁言成功`,
        });
    }

    frozenIP(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let fip = req.query.frozen_ip;
        let roleid = req.query.roleid;
        let id = parseInt(req.query.id);
        if (!fip && !id) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `封禁失败，需要有效的frozen_ip参数!`
            });
            return;
        }

        FrozenIPMgr.shared.addFrozenIP(fip,id);
        //通知当前IP下的所有玩家下线
        let roleList: any = [];
        roleList.push(roleid);
        DB.getFrozenIpRoleid(fip, (ret: any, ipList: any) => {
            if (ret == MsgCode.SUCCESS) {
                for (let ip of ipList) {
                    roleList.push(ip.roleid);
                }
                ServerMgr.shared.sendAllServer('/kicked_out', {
                    roleids: roleList,
                    sign:sign
                });
            }
        });
        Http.reply(res, {
            code: MsgCode.SUCCESS,
            msg: `封禁${fip}成功!`
        });
    }
    // 解封IP
    unfrozenIP(req: any, res: any) {
        let fip = req.query.frozen_ip;
        let id = parseInt(req.query.id);
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        FrozenIPMgr.shared.removeFrozenIP(fip,id);
        Http.reply(res, {
            code: MsgCode.SUCCESS,
            msg: `解封${fip}成功!`
        });
    }
    // 封设备
    frozenMAC(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let account_id = req.query.account_id;
        let gm_role_id = req.query.gm_role_id;
        if (!gm_role_id) {
            gm_role_id = 0;
        }
        DB.freezeMAC({
            account_id: account_id,
            gm_role_id: gm_role_id
        }, (code: number, msg: string, mac: string) => {
            if (mac && mac.length > 0) {
                FrozenMacMgr.shared.addFrozenMAC(mac);
                DB.getFrozenMacRoleid(mac, (ret: any, rows: any) => {
                    if (ret == MsgCode.SUCCESS) {
                        let roleList = [];
                        for (let data of rows) {
                            roleList.push(data.roleid);
                        }
                        ServerMgr.shared.sendAllServer('/kicked_out', {
                            roleids: roleList,
                            sign:sign
                        });
                    }
                });
            }
            Http.reply(res, {
                code: code,
                msg: msg
            });
        });
    }

    // 解封设备
    unfrozenMAC(req: any, res: any) {
        let account_id = req.query.account_id;
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        DB.unfreezeMAC({
            account_id: account_id
        }, (code: number, msg: string, mac: string) => {
            if (code == MsgCode.SUCCESS) {
                FrozenMacMgr.shared.removeFrozenMAC(mac);
                Http.reply(res, {
                    code: code,
                    msg: msg
                });
            }
        });
    }

    // 清除玩家缓存
    clearPlayerCache(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let roleid = req.query.id;
        ServerMgr.shared.sendAllServer('/clear_pcache', {
            roleid: roleid,
        });
        res.end(SKDataUtil.toJson({
            code: MsgCode.SUCCESS,
            msg: `操作完成`
        }, "{}"));
    }
    // 加仙玉
    addJade(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `游戏已关服,不能发放仙玉给玩家!`
            });
            return;;
        }
        let roleId = req.query.role_id;
        let jade = parseInt(req.query.jade);
        jade = Math.min(990000000, jade);
        let invite = req.query.invite;
        DB.addJade(roleId, jade, (code: number) => {
            if (code == MsgCode.SUCCESS) {
                ServerMgr.shared.sendServer(roleId, "/add_jade",
                    { roleId: roleId, jade: jade, invite: invite,sign: sign },
                    (success: boolean, data: any) => {
                        if (success) {
                            res.end(SKDataUtil.toJson({
                                code: code,
                                msg: `${roleId}加仙玉${jade}成功`,
                            }, "{}"));
                        } else {
                            res.end(SKDataUtil.toJson({
                                code: code,
                                msg: `${roleId}加仙玉${jade}失败`,
                            }, "{}"));
                        }
                    })
                return;
            }
            res.end(SKDataUtil.toJson({
                code: code,
                msg: `${roleId}加仙玉${jade}失败`,
            }, "{}"));
        })
    }
    // 加经验值
    addExp(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `游戏已关服,不能发放经验给玩家!`
            });
            return;;
        }
        let roleId = req.query.role_id;
        let exp = parseInt(req.query.exp);
        exp = Math.min(9999999999, exp);
        let invite = req.query.invite;
        if (!invite) {
            invite = "";
        }
        ServerMgr.shared.sendServer(roleId, '/add_exp', {
            roleId: roleId,
            exp: exp,
            invite: invite,
			sign: sign
        }, (success: boolean, data: any) => {
            SKLogger.debug(`${roleId}加经验${exp}:${success}`);
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `角色${roleId}加经验${exp}成功`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `角色${roleId}加经验${exp}失败:${data}`,
                }, "{}"));
            }
        });
    }
    //模拟战斗
    testBattle(req: any, res: any){
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `游戏已关服`
            });
            return;
        }
        let roleId = req.query.role_id;
        let eroleId = req.query.eroleid;
        let invite = req.query.invite;
        ServerMgr.shared.sendServer(roleId, '/test_battle', {
            roleId: roleId,
            eroleid: eroleId,
            invite: invite
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `开始战斗`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `请求失败`,
                }, "{}"));
            }
        });
    }
    // 加道具
    addItem(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `游戏已关服,不能发放道具给玩家!`
            });
            return;;
        }
        let roleId = req.query.role_id;
        let item = parseInt(req.query.item);
        if (isNaN(item)) {
            let msg = `角色[${roleId}]加道具,道具索引无效`;
            res.end(SKDataUtil.toJson({
                code: MsgCode.FAILED,
                msg: msg,
            }, "{}"));
            SKLogger.debug(msg);
            return;
        }
        let num = parseInt(req.query.num);
        if (isNaN(item)) {
            let msg = `角色${roleId}加道具,数量无效`
            res.end(SKDataUtil.toJson({
                code: MsgCode.FAILED,
                msg: msg,
            }, "{}"));
            SKLogger.debug(msg);
            return;
        }
        if (item == 90003) {
            num = Math.min(100000000, num);
        } else {
            num = Math.min(10000, num);
        }
        let invite = req.query.invite;
        if (!invite) {
            invite = "";
        }
        ServerMgr.shared.sendServer(roleId, '/add_item', {
            roleId: roleId,
            item: item,
            num: num,
            invite: invite,
			sign: sign
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `加道具:[${roleId}]获得[${item}:数量${num}]${success}`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `加道具:[${roleId}]获得[${item}:数量${num}]${success}`,
                }, "{}"));
            }
        });
    }

    //发送天策符
    addOfuda(req: any, res: any){
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `游戏已关服,不能发放道具给玩家!`
            });
            return;;
        }
        let roleId = req.query.role_id;
        let name = req.query.name;            //天策符名称
        let grade = req.query.grade;          //品级
        let addition = req.query.addition;    //加成
        let invite = req.query.invite;
        if (!invite) {
            invite = "";
        }
        ServerMgr.shared.sendServer(roleId, '/add_ofuda', {
            roleId: roleId,
            name: name,
            grade: grade,
            addition: addition,
            invite: invite,
			sign: sign
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `[${roleId}]获得[${req.query.name}]${success}`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `[${roleId}]获得[${req.query.name}]${success}`,
                }, "{}"));
            }
        });
    }

    // 获得物品列表
    getItemList(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let list = GoodsMgr.getItemList();
        res.end(SKDataUtil.toJson({
            code: MsgCode.SUCCESS,
            list: SKDataUtil.toJson(list, "[]"),
        }, "{}"));
    }
    // 加称谓
    addTitle(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        // title = { "type": type, "titleid": titleId, "value": value, "onload": onload }
        let role_id = req.query.role_id;
        let type = req.query.type;
        if (!type) {
            type = 1;
        }
        let title_id = req.query.title_id;
        if (!title_id) {
            title_id = 1;
        }
        let value = req.query.value;
        let onload = req.query.onload;
        ServerMgr.shared.sendServer(role_id, '/add_title', {
            role_id: role_id,
            type: type,
            title_id: title_id,
            value: value,
            onload: onload
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `${role_id}加称谓成功,${success}`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `${role_id}加道具失败,${success}`,
                }, "{}"));
            }
        });
    }
    // 更改现金提现状态
    obtainCurrency(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let msg = req.query.msg;
        let role_id = req.query.role_id;
        ServerMgr.shared.sendServer(role_id, '/obtain_currency', {
            role_id: role_id,
            msg: msg,
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `${role_id}成功,${success}`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `${role_id}失败,${success}`,
                }, "{}"));
            }
        });
    }

    // 更改现金提现状态
    updateWithdrawState(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let state = req.query.state;
        let serial = req.query.serial;
        let role_id = req.query.role_id;

        ServerMgr.shared.sendServer(role_id, '/withdraw_state', {
            role_id: role_id,
            state: state,
            serial: serial
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `${role_id}提现状态更改成功,${success}`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `${role_id}提现状态更改失败,${success}`,
                }, "{}"));
            }
        });
    }
    // 提交异常日志
    report(req: any, res: any) {
        let params = req.body;
        let roleId = params.roleId;
        let msg = params.msg;
        msg.replace("\'", "\\\'");
        msg.replace("\"", "\\\"");
        if (this.reportKey.indexOf(msg) != -1) {
            Http.reply(res, {
                code: 1
            })
            return;
        }
        let version = params.version;
        if (!version) {
            version = "";
        }
        let platfrom = params.platform;
        let ip = this.getClientIP(req, res);
        Http.reply(res, {
            code: 0
        })
        console.warn(`$前端异常:角色索引[${roleId}]\n消息:${msg},\n版本:${version},平台:${platfrom},IP:${ip}`);
        this.reportKey.push(msg);
    }

    kickedOut(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let role_id = req.query.role_id;
        if (!role_id) {
            res.end(SKDataUtil.toJson({
                code: MsgCode.FAILED,
                msg: `缺少role_code参数!`,
            }, "{}"));
        }
        ServerMgr.shared.sendAllServer('/kicked_out', {
            roleids: [role_id],
            sign: sign
        });
        res.end(SKDataUtil.toJson({
            code: MsgCode.SUCCESS,
            msg: `角色${role_id}被踢!`,
        }, "{}"));
    }
    // 清除指定玩家的每日存档
    clearDay(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let type = (req.query.type ? req.query.type : 0);
        let roleId = req.query.role_id;
        ServerMgr.shared.sendServer(roleId, '/clear_day', {
            type: type,
            roleId: roleId
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `${roleId}清除每日存档成功`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `${roleId}清除每日存档成功`,
                }, "{}"));
            }
        });
    }


    // 清理玩家任务
    closeTask(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }

        let roleId = req.query.role_id;
        ServerMgr.shared.sendServer(roleId, '/close_task', {
            roleId: roleId
        }, (success: boolean, data: any) => {
            if (success) {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.SUCCESS,
                    msg: `${roleId}清除每日任务成功`,
                }, "{}"));
            } else {
                res.end(SKDataUtil.toJson({
                    code: MsgCode.FAILED,
                    msg: `${roleId}清除每日任务失败`,
                }, "{}"));
            }
        });
    }

    /**
     * 恢复数据
     * @param req
     * @param res
     */
    rollbackPlayer(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let roleId = req.query.role_id;
        let server_id = req.query.server_id;
        let server_list = [];
        let server = ServerMgr.shared.getServer(server_id);
        if (server) {
            server_list.push(server);
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `恢复数据:找不到未开闭的服务器!`
            });
            return;
        }
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, '/roll_back_player', {
                roleId: roleId
            }, (success: boolean, data: any) => {
                if (data.code == MsgCode.SUCCESS) {
                    res.end(SKDataUtil.toJson({
                        code: MsgCode.SUCCESS,
                        msg: `${roleId}恢复数据，${data.msg}`,
                    }, "{}"));
                } else {
                    res.end(SKDataUtil.toJson({
                        code: MsgCode.FAILED,
                        msg: `${roleId}恢复数据失败，${data.msg}`,
                    }, "{}"));
                }
            });
        }
    }

    // 清除所有玩家的每日存档
    clearAllDay(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let server_id = req.query.server_id; // 0 则全服公告
        if (!server_id) {
            server_id = 0;
        }
        let server_list = [];
        if (server_id == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        } else {
            let server = ServerMgr.shared.getServer(server_id);
            if (server) {
                server_list.push(server);
            }
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `清理所有玩家每日存档:找不到未开闭的服务器!`
            });
            return;
        }
        let index = 0;
        let info = ``;
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, '/clear_all_day', {
            }, (success: boolean, data: any) => {
                index++;
                info += `${info.length < 1 ? `` : `,`}${data.msg}`;
                if (index == server_list.length) {
                    Http.reply(res, {
                        code: data.code,
                        msg: info
                    });
                }
            });
        }
    }
    // 控制
    control(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let type = (req.query.type ? req.query.type : 0);
        let open = (req.query.open ? req.query.open : 1);
        ServerMgr.shared.sendAllServer("/control", {
            type: type,
            open: open
        }, (success: boolean, data: any) => {
            Http.reply(res, {
                code: data.code,
                msg: data.msg
            });
        });
    }
    // 全部玩家存档
    saveAll(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let server_id = req.query.server_id; // 0 则全服存档
        if (!server_id) {
            server_id = 0;
        }
        let server_list = [];
        if (server_id == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        } else {
            let server = ServerMgr.shared.getServer(server_id);
            if (server) {
                server_list.push(server);
            }
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `全部存档:找不到未开闭的服务器!`
            });
            return;
        }
        let total = server_list.length;
        let count = 0;
        let msg = ``;
        let list: any[] = [];
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, '/save_all', {
            }, (success: boolean, data: any) => {
                count++;
                msg += `${msg.length < 1 ? `` : `,`}${data.msg}`;
                list.push(data);
                if (count == total) {
                    Http.reply(res, {
                        code: data.code,
                        msg: msg,
                        data: list
                    });
                }
            });
        }
    }

    // 备用存档
    saveAllReserve(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let server_id = req.query.server_id; // 0 则全服存档
        if (!server_id) {
            server_id = 0;
        }
        let server_list = [];
        if (server_id == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        } else {
            let server = ServerMgr.shared.getServer(server_id);
            if (server) {
                server_list.push(server);
            }
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `全部存档:找不到未开闭的服务器!`
            });
            return;
        }
        let total = server_list.length;
        let count = 0;
        let msg = ``;
        let list: any[] = [];
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, '/save_all_reserve', {
            }, (success: boolean, data: any) => {
                count++;
                msg += `${msg.length < 1 ? `` : `,`}${data.msg}`;
                list.push(data);
                if (count == total) {
                    Http.reply(res, {
                        code: data.code,
                        msg: msg,
                        data: list
                    });
                }
            });
        }
    }

    // 关服
    close(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        GameUtil.isClose = true;
        let server_id = req.query.server_id; // 0 则全服公告
        if (!server_id) {
            server_id = 0;
        }
        let server_list = [];
        if (server_id == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        } else {
            let server = ServerMgr.shared.getServer(server_id);
            if (server) {
                server_list.push(server);
            }
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            let msg = `关服:找不到未开闭的服务器!`;
            SKLogger.info(msg);
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: msg
            });
            return;
        }
        let total = server_list.length;
        let count = 0;
        let msg = ``;
        let list: any[] = [];
        for (let server of server_list) {
            SKLogger.info(`正在关闭服务器:${server.name}`);
            Http.sendget(server.net_ip, server.http_port, '/close', {
            }, (success: boolean, data: any) => {
                count++;
                msg += `${msg.length < 1 ? `` : `,`}${data.msg}`;
                list.push(data);
                if (count == total) {
                    Http.reply(res, {
                        code: data.code,
                        msg: msg,
                        data: list
                    });
                }
            });
        }
    }
    // 发送邮件
    sendMail(req: any, res: any) {
        // let sign = req.query.sign; // 签名
        // if (sign != GameConf.sign) {
        //     Http.reply(res, {
        //         code: MsgCode.FAILED,
        //         msg: `非法请求!`
        //     });
        //     return;
        // }
        if (GameUtil.isClose) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `游戏已关服,不能发送邮件!`
            });
            return;;
        }
        let target = req.query.target;
        let title = req.query.title;
        let content = req.query.content;
        let gets = req.query.gets;
        // 发送全服 S:1000 发送1区 R:0 发送角色编号 I:ABCDE 发送邀请码玩家
        let data: any = {
            target: target,
            title: title,
            content: content,
            gets: gets
        };
        if (SKDataUtil.isEmptyString(target)) {
            ServerMgr.shared.sendAllServer("/send_mail", data, (success: boolean, data: any) => {
                if (success) {
                    res.end(SKDataUtil.toJson({
                        code: MsgCode.SUCCESS,
                        msg: `发送邮件成功!`,
                    }, "{}"));
                } else {
                    res.end(SKDataUtil.toJson({
                        code: MsgCode.FAILED,
                        msg: `发送邮件失败`,
                    }, "{}"));
                }
            });
        } else {
            let params = target.split(":");
            if (params.length != 2) {
                Http.reply(res, {
                    code: MsgCode.FAILED,
                    msg: `发送邮件:目标字符串错误!`
                });
                return;
            }
            let prefix = params[0];
            switch (prefix) {
                case "S":
                    let serverId = SKDataUtil.numberBy(params[1]);
                    ServerMgr.shared.getServer(serverId).send("/send_mail", data, (success: boolean, data: any) => {
                        if (success) {
                            res.end(SKDataUtil.toJson({
                                code: MsgCode.SUCCESS,
                                msg: `发送邮件成功!`,
                            }, "{}"));
                        } else {
                            res.end(SKDataUtil.toJson({
                                code: MsgCode.FAILED,
                                msg: `发送邮件失败`,
                            }, "{}"));
                        }
                    });
                    break;
                case "R":
                    data.roleId = SKDataUtil.numberBy(params[1]);
                    ServerMgr.shared.sendServer(data.roleId, "/send_mail", data, (success: boolean, data: any) => {
                        if (success) {
                            res.end(SKDataUtil.toJson({
                                code: MsgCode.SUCCESS,
                                msg: `发送邮件成功!`,
                            }, "{}"));
                        } else {
                            res.end(SKDataUtil.toJson({
                                code: MsgCode.FAILED,
                                msg: `发送邮件失败`,
                            }, "{}"));
                        }
                    });
                    break;
                case "I":
                    data.invite = params[1];
                    ServerMgr.shared.sendAllServer("/send_mail", data, (success: boolean, data: any) => {
                        if (success) {
                            res.end(SKDataUtil.toJson({
                                code: MsgCode.SUCCESS,
                                msg: `发送邮件成功!`,
                            }, "{}"));
                        } else {
                            res.end(SKDataUtil.toJson({
                                code: MsgCode.FAILED,
                                msg: `发送邮件失败`,
                            }, "{}"));
                        }
                    });
                    break;
            }
        }
    }
    // 获得服务器列表
    getServerList(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }
        let dict = ServerMgr.shared.getServerList();
        let result = [];
        for (let key in dict) {
            let server = dict[key];
            result.push(server.toObj());
        }
        res.end(SKDataUtil.toJson({
            code: MsgCode.SUCCESS,
            msg: `发送邮件成功!`,
            data: result,
        }, "{}"));
    }

    // 同步数据
    syncData(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }

        let server_id = req.query.server_id; // 0 则全服
        let path = req.query.path; // 接口名称
        if (!server_id) {
            server_id = 0;
        }
        let server_list = [];
        if (server_id == 0) {
            let servers = ServerMgr.shared.getServerList();
            for (let key in servers) {
                server_list.push(servers[key]);
            }
        } else {
            let server = ServerMgr.shared.getServer(server_id);
            if (server) {
                server_list.push(server);
            }
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `未开闭的服务器`
            });
            return;
        }
        let index = 0;
        let info = ``;
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, path, {
            }, (success: boolean, data: any) => {
                index++;
                info += `${info.length < 1 ? `` : `,`}${data.msg}`;
                if (index == server_list.length) {
                    Http.reply(res, {
                        code: data.code,
                        msg: info
                    });
                }
            });
        }
    }

    //  清理机器人数据
    clearRobot(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }

        let server_id = req.query.server_id;

        let server_list = [];
        let server = ServerMgr.shared.getServer(server_id);
        if (server) {
            server_list.push(server);
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `未开闭的服务器`
            });
            return;
        }
        let index = 0;
        let info = ``;
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, "/clear_robot", {
                num: req.query.num
            }, (success: boolean, data: any) => {
                index++;
                info += `${info.length < 1 ? `` : `,`}${data.msg}`;
                if (index == server_list.length) {
                    Http.reply(res, {
                        code: data.code,
                        msg: info
                    });
                }
            });
        }
    }

    //  创建机器人数据
    createRobot(req: any, res: any) {
        let sign = req.query.sign; // 签名
        if (sign != GameConf.sign) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `非法请求!`
            });
            return;
        }

        let server_id = req.query.server_id;

        let server_list = [];
        let server = ServerMgr.shared.getServer(server_id);
        if (server) {
            server_list.push(server);
        }
        server_list = server_list.filter(t => t.is_reg);
        if (server_list.length < 1) {
            Http.reply(res, {
                code: MsgCode.FAILED,
                msg: `未开闭的服务器`
            });
            return;
        }
        let index = 0;
        let info = ``;
        for (let server of server_list) {
            Http.sendget(server.net_ip, server.http_port, "/create_robot", {
                num: req.query.num
            }, (success: boolean, data: any) => {
                index++;
                info += `${info.length < 1 ? `` : `,`}${data.msg}`;
                if (index == server_list.length) {
                    Http.reply(res, {
                        code: data.code,
                        msg: info
                    });
                }
            });
        }
    }

    // 启动Http服务
    start(port: number) {
        let list: { [key: string]: (req: any, res: any) => void } = {
            ['register_server']: this.registerServer.bind(this),
            ['ping_server']: this.pingServer.bind(this),
            ['register']: this.register.bind(this),
            ["login"]: this.login.bind(this),
            ['create_role']: this.createRole.bind(this),
            ['ser_list']: this.serList.bind(this),
            ['to_server']: this.toServer.bind(this),
            ['charge']: this.charge.bind(this),
            ['pay_return']: this.payReturn.bind(this),
			['pay_notify']: this.payNotify.bind(this),
            ['get_comment']: this.getComment.bind(this),
            ['say_set_comment']: this.setComment.bind(this),
            ['say_sys_notice']: this.sysNotice.bind(this),
            ['say_online_num']: this.onlineNum.bind(this),
            // 禁言
            ['say_not_speak']: this.notSpeak.bind(this),
            // 解言
            ['say_can_speak']: this.canSpeak.bind(this),
            // 封IP
            ['say_frozen_ip']: this.frozenIP.bind(this),
            // 解封IP
            ['say_unfrozen_ip']: this.unfrozenIP.bind(this),
            ['say_frozen_mac']: this.frozenMAC.bind(this),
            ['say_unfrozen_mac']: this.unfrozenMAC.bind(this),
            ['say_clear_player_cache']: this.clearPlayerCache.bind(this),
            ['say_change_password']: this.changePassword.bind(this),
            ['say_set_charge_activity']: this.setChargeActivity.bind(this),
            ['say_open_charge_activity']: this.openChargeActivity.bind(this),
            ['say_close_charge_activity']: this.closeChargeActivity.bind(this),
            ['say_get_charge_activity']: this.getChargeActivity.bind(this),
            // 恢复数据
            ["say_roll_back_player"]: this.rollbackPlayer.bind(this),
            // 清理玩家任务
            ["say_close_task"]: this.closeTask.bind(this),
            // 给指定的玩家加仙玉
            ['say_add_jade']: this.addJade.bind(this),
            // 给指定的玩家加经验
            ['say_add_exp']: this.addExp.bind(this),
            // 给指定的玩家加道具
            ['say_add_item']: this.addItem.bind(this),
            // 给指定的玩家加道具
            ['say_add_ofuda']: this.addOfuda.bind(this),
            // 获得道具列表
            ['say_get_item_list']: this.getItemList.bind(this),
            // 代理充值
            ['say_agent_charge']: this.agentCharge.bind(this),
            // 加称谓
            ["say_add_title"]: this.addTitle.bind(this),
            // 踢指定的玩家
            ["say_kicked_out_player"]: this.kickedOut.bind(this),
            // 清除指定玩家每日存档
            ["say_clear_day"]: this.clearDay.bind(this),
            // 清除所有玩家每日存档
            ["say_clear_all_day"]: this.clearAllDay.bind(this),
            // 全部玩家存档
            ["say_save_all"]: this.saveAll.bind(this),
            // 备用存档
            ["save_all_reserve"]: this.saveAllReserve.bind(this),
            // 控制
            ["say_control"]: this.control.bind(this),
            // 关服
            ["say_close"]: this.close.bind(this),
            // 发送邮件
            ["say_send_mail"]: this.sendMail.bind(this),
            // 更改提现状态
            ["say_withdraw_state"]: this.updateWithdrawState.bind(this),
            // 获得现金
            ["say_obtain_currency"]: this.obtainCurrency.bind(this),
            // 同步数据
            ["say_sync_data"]: this.syncData.bind(this),
            // 创建机器人数据
            ["say_create_robot"]: this.createRobot.bind(this),
            // 清理机器人数据
            ["say_clear_robot"]: this.clearRobot.bind(this),
            // 获得服务器列表
            ["server_list"]: this.getServerList.bind(this),
            ['test_battle']: this.testBattle.bind(this),
        };
        for (let key in list) {
            //异步通知接收post请求
            if(key=="pay_notify"){
                this.app.post('/' + key, list[key]);
            }else{
                this.app.get('/' + key, list[key]);
            }
        }
        this.app.post("/report", this.report.bind(this));
        this.app.listen(port);
    }
}
