import DB from "./DB";
import ChargeConfig from "../core/ChargeConfig";
import ServerMgr from "../gate/ServerMgr";
import Http from "./Http";
import SKLogger from "../gear/SKLogger";
import SKDataUtil from "../gear/SKDataUtil";
import { MsgCode } from "../role/EEnum";
import GameConf from "../../conf/GameConf";
let request = require('sync-request');
let http = require('http');
import * as crypto from "crypto";
/*-------------- 元宝支付平台（18pay.net）配置开始 -----------------*/
let userId = "20206491";//商户编号
let userKey = "7FAd7Bb448dc2909cE55769D5Eef8F27";//商户密钥
let payURL = "https://www.18pay.net/pay.html";
/*-------------- 元宝支付平台（18pay.net）配置结束 -----------------*/
// 充值
export default class Charge {
	static shared = new Charge();
	orderList: any;

	constructor() {
		this.orderList = {};
	}

	/*
	 * 获取随机的20位的订单号
	 */
	getRandomOrderid20() {
		let date = new Date();
		let second = date.getTime();
		let random = Math.floor(900000 * Math.random()) + 100000;
		let orderid = 'E' + second + '' + random;
		return orderid;
	}

	getAgentOrderid20() {
		let date = new Date();
		let second = date.getTime();
		let random = Math.floor(900000 * Math.random()) + 100000;
		let orderid = 'A' + second + '' + random;
		return orderid;
	}


	/*
	 * 创建自定义订单
	 */
	createCustomOrder(roleid: any, goodsid: any, goodscount: any, pay_bankcode: any, money: any, activitystates: any, type: any, callback: any) {
		if ([210, 220, 310, 330].indexOf(pay_bankcode) == -1) {
			callback(false);
			return;
		}
		money = parseInt(money);
		if (isNaN(money)) {
			callback(false);
			return;
		}
		let jade = this.getAllJadeByMoney(money);
		let orderid = this.getRandomOrderid20();
		DB.createChargeOrder(orderid, roleid, money, jade, goodscount, goodsid, activitystates, type,(ret: any) => {
			if (!ret) {
				callback(false, {});
				return;
			}
			let url = this.getPayH5(roleid, orderid, money, pay_bankcode,type);
			callback(true, { url: url });
		});
	}

	/*
	 * 创建订单
	 * @param roleid 角色id
	 * @param goodsid 货物pid
	 * @param goodscount 货品数量
	 * @param pay_bankcode 支付类型
	 * @param activitystates 双倍充值活动是否开启
	 * @param money 价格
	 */
	createOrder(roleid: any, goodsid: any, goodscount: any, pay_bankcode: any, money: any, activitystates: any, type: any, callback: any) {
		if (goodsid == 0) {
			this.createCustomOrder(roleid, goodsid, goodscount, pay_bankcode, money, activitystates, type, callback);
			return;
		}
		if ([210, 220, 310, 330].indexOf(pay_bankcode) == -1) {
			callback(false);
			return;
		}
		let jade = 0;
		let name = '';
		// 仙玉充值
		if (type == 1){
			goodscount = 1;
			let list = ChargeConfig.shared.charge_list;
			for (let data of list) {
				if (data.goodsid == goodsid) {
					jade = (data.jade + data.ex_jade) * goodscount;
					money = data.money * goodscount;
					name = data.name;
					break;
				}
			}
		}else {
			// 道具充值
			let list = ChargeConfig.shared.charge_goods_list;
			for (let data of list) {
				if (data.goodsid == goodsid) {
					money = data.money * goodscount;
					name = data.name;
					break;
				}
			}
		}

		if (money == 0 || name == '') {
			callback(false);
			return;
		}
		let orderid = this.getRandomOrderid20();
		DB.createChargeOrder(orderid, roleid, money, jade, goodscount, goodsid, activitystates, type,(ret: any) => {
			if (!ret) {
				callback(false, {});
				return;
			}
			let url = this.getPayH5(roleid, orderid, money, pay_bankcode ,type);
			callback(true, { url: url });
		});
	}
	// 获得支付H5地址
	getPayH5(roleId: string, orderId: string, money: number, type: number, is_goods: number): string {
		// 订单编号
		let payid = orderId;
		// 订单金额
		//money = money.toFixed(2);
		// 支付方式
		let paytype = "1";
		if (type == 330 || type == 310) {
			paytype = "2";
		}
		let path = GameConf.charge_notify;
		// 异步通知
		let notifyurl = `${path}/pay_notify`;
		// 同步跳转
		let returnurl = `${path}/pay_return`;
		notifyurl = encodeURI(notifyurl);
		returnurl = encodeURI(returnurl);
		// 订单备注
		let subject = roleId;
		// 计算签名
		let content = `appid=${userId}&money=${money}&notify_url=${notifyurl}&payid=${payid}&return_url=${returnurl}&subject=${subject}&type=${paytype}${userKey}`;
		let sign = crypto.createHash("md5").update(content, 'utf8').digest("hex");
		let result = `${payURL}?appid=${userId}&money=${money}&notify_url=${notifyurl}&payid=${payid}&return_url=${returnurl}&subject=${subject}&type=${paytype}&sign=${sign}`;
		return result;


	}

	getItem(i: any) {
		let config = ChargeConfig.shared.charge_list;
		for (let item of config) {
			if (item.goodsid == i) {
				return item;
			}
		}
		return null;
	}
	/*
	 * 自定义订单根据money计算jade
	 */
	getAllJadeByMoney(money: any) {
		let jade = money * 100;
		let exjade = 0;
		for (let i = 6; i >= 1; --i) {
			let item = this.getItem(i);
			if (item && money >= item.money) {
				let count = Math.floor(money / item.money);
				exjade += count * item.ex_jade;
				money -= count * item.money;
			}
		}
		return jade + exjade;
	}

	// 充值同步跳转
	pay_return(req: any, res: any) {
		let pay_id = req.query.pay_id;
		let pay_money = req.query.pay_money;
		let pay_no = req.query.pay_no;
		let pay_time = req.query.pay_time;
		let pay_type = req.query.pay_type;
		let sign = req.query.sign;
		let subject = req.query.subject;
		let content = `pay_id=${pay_id}&pay_money=${pay_money}&pay_no=${pay_no}&pay_time=${pay_time}&pay_type=${pay_type}&subject=${subject}${userKey}`;
		let my_sign = crypto.createHash("md5").update(content, 'utf8').digest("hex");
		if (sign == my_sign) {
			if (pay_no!=null) {
				//this.paySuccess(pay_id, pay_id, pay_money);
				res.end(`充值${pay_money}元成功!`);
			} else {
				res.end(`充值${pay_money}元失败!`);
			}
		} else {
		    SKLogger.debug(`同步跳转签名错误，参与签名数据：${content}`);
			res.end(`充值${pay_money}元失败,签名错误!`);
		}
	}

	// 充值异步通知
	pay_notify(req: any, res: any) {
		let pay_id = req.body.pay_id;
		let pay_money = req.body.pay_money;
		let pay_no = req.body.pay_no;
		let pay_time = req.body.pay_time;
		let pay_type = req.body.pay_type;
		let sign = req.body.sign;
		let content = `pay_id=${pay_id}&pay_money=${pay_money}&pay_no=${pay_no}&pay_time=${pay_time}&pay_type=${pay_type}${userKey}`;
		let my_sign = crypto.createHash("md5").update(content, 'utf8').digest("hex");
		if (sign == my_sign) {
			if (pay_no!=null) {
				console.log(`异步通知:充值${pay_money}元成功!`);
				this.paySuccess(pay_id, pay_id, pay_money);
				res.end(`success`);
			} else {
				console.log(`异步通知:充值${pay_money}元失败!`);
				res.end(`fall`);
			}
		} else {
		    SKLogger.debug(`异步通知签名错误，参与签名数据：${content}`);
			console.log(`异步通知:充值订单${pay_money}签名失败!`);
			res.end(`fall`);
		}
	}


	// 充值成功处理
	paySuccess(sdorderno: string, sdpayno: string, total_fee: string) {

		if (this.orderList[sdorderno]) {
			SKLogger.debug(`订单${sdorderno}正在处理...`);
			return;
		}
		this.orderList[sdorderno] = 0;
		DB.canFinishOrder(sdorderno, sdpayno, total_fee, (code: MsgCode, row: any) => {
			if (row == null) {
				delete this.orderList[sdorderno];
				return;
			}
			let type = SKDataUtil.numberBy(row.type);
			let goodsid = SKDataUtil.numberBy(row.goodsid);

			let sd_money = SKDataUtil.numberBy(row.money);
			let server = ServerMgr.shared.getServer(row.serverid);
			if (server == null || server.net_ip == null || !server.http_port == null) {
				delete this.orderList[sdorderno];
				SKLogger.warn(`支付:玩家充值[${total_fee}]元失败,找不到所在游戏服务器!`);
				return;
			}
			let list = ChargeConfig.shared.charge_list;
			let goodscount = SKDataUtil.numberBy(row.goodscount);
			let itemid = 0;
			let num = 1;

			// 1是仙玉 0 是道具
			if (type == 0) {
				list = ChargeConfig.shared.charge_goods_list
				for (let data of list) {
					if (data.goodsid == goodsid) {
						itemid = data.itemid;
						num = data.num * goodscount;
					}
				}
			}
			Http.sendget(server.net_ip, server.http_port, '/charge_callback', {
				roleid: row.roleid,
				sdorderno: sdorderno,
				sdpayno: sdpayno,
				jade: row.jade,
				sd_money: sd_money,
				total_fee: total_fee,
				itemid: itemid,
				num: num,
				type: type,
				sign: GameConf.sign,
			}, (success: boolean, data: any) => {
				delete this.orderList[sdorderno];
				if (!success) {
					return;
				}
				if (data.code == MsgCode.SUCCESS) {
					DB.setOrderFinish(sdorderno, sdpayno, total_fee, (success: boolean) => {
						if (success) {
							SKLogger.info(`支付:玩家[${row.roleid}]充值${total_fee}元成功!`);
							DB.agentDivide({ money: total_fee, roleId: row.roleid });
						} else {
							SKLogger.info(`支付:玩家[${row.roleid}]充值${total_fee}元失败!`);
						}
					});
				}
			});


		});
	}
	// 代理充值
	agentCharge(role_id: string, charge_id: number, count: number, activitystates: any, callback: (code: number, msg: string) => void) {
	SKLogger.warn(`代理充值玩家：[${role_id}:${charge_id}]`);
		let list = ChargeConfig.shared.charge_list;
		if (charge_id < 1 || charge_id > list.length) {
			callback(MsgCode.FAILED, `代理充值:charge_id配置没有找到!`);
			return;
		}
		let data = list[charge_id - 1];
		let goodsid = data.goodsid;
		let jade = (data.jade + data.ex_jade) * count;
		let money = data.money * count;
		let order_id = this.getAgentOrderid20();
		DB.agentCharge(order_id, role_id, money, jade, count, goodsid, activitystates, (code: number, msg: string, server_id: any) => {
			if (code == MsgCode.SUCCESS) {
				this.agentPaySuccess(order_id, role_id, jade, money, server_id, callback);
			} else {
				callback(code, msg);
			}
		});
	}

	agentPaySuccess(order_id: string, roleId: any, jade: number, money: number, server_id: any, callback: (code: number, msg: string) => void) {
		let server = ServerMgr.shared.getServer(server_id);
		if (!server || !server.net_ip || !server.http_port) {
			callback(MsgCode.FAILED, `代理充值${money}元失败,找不到所在游戏服务器!`);
			return;
		}
		Http.sendget(server.net_ip, server.http_port, '/charge_callback', {
			roleid: roleId,
			sdorderno: order_id,
			sdpayno: "",
			jade: jade,
			sd_money: money,
			total_fee: money,
		}, (ret: any, data: any) => {
			callback(MsgCode.SUCCESS, `代理充值${money}元成功!`);
		});
	}
	
	


	archCharge(role_id: string, charge_id: number, count: number, activitystates: any, callback: (code: number, msg: string) => void) {
		SKLogger.warn(`玩家充值券：[${role_id}:${charge_id}]`);
		let list = ChargeConfig.shared.charge_list;
		if (charge_id < 1 || charge_id > list.length) {
			callback(MsgCode.FAILED, `代理充值:charge_id配置没有找到!`);
			return;
		}
		let data = list[charge_id - 1];
		let goodsid = data.goodsid;
		let jade = (data.jade + data.ex_jade) * count;
		let money = data.money * count;
		let order_id = this.getAgentOrderid20();
		DB.agentCharge(order_id, role_id, money, jade, count, goodsid, activitystates, (code: number, msg: string) => {
			if (code == MsgCode.SUCCESS) {
				callback(code, order_id);
			} else {
				callback(code, msg);
			}
		});
	}


}
