﻿<?php
ini_set("error_reporting", "E_ALL & ~E_NOTICE");
header('Content-Type:application/json; charset=utf-8');
require "Des.php";
/////////////////需要修改的参数/////////////////
//商户编号
$appid = '填写平台的商户编号';
//商户密钥
$appkey = '填写平台的商户密钥';
//算法密钥
$deskey = '填写平台的算法密钥';
//服务器列表
$serverlist = [
	1 => ["name" => "一番队", "url" => "http://192.168.1.1:881"],
	2 => ["name" => "二番队", "url" => "http://192.168.1.1:882"], 
	3 => ["name" => "三番队", "url" => "http://192.168.1.1:883"], 
	4 => ["name" => "四番队", "url" => "http://192.168.1.1:884"], 
	5 => ["name" => "五番队", "url" => "http://192.168.1.1:885"], 
	6 => ["name" => "六番队", "url" => "http://192.168.1.1:886"]
];
///////////////////////////////////////////////
//下面代码基本不需要修改
if (empty($_POST)) $_POST = $_GET;  //如果为GET方式访问
if(version_compare(PHP_VERSION,'5.4.0','<')){
	outputError('PHP版本要求大于5.4.0');
}
if(!isset($_POST['appid'])){
	outputError('参数非法');
}
//验证商户号
if($_POST['appid']!=$appid){
	outputError('商户编号不正确');
}
if (!function_exists('openssl_encrypt')){
	outputError('请开启php.ini的openssl扩展');
}
//解密接口参数
$des = new Des();
$parameter=$_POST['parameter'];
$decode=$des->decrypt($parameter,$deskey);
if(empty($decode)){
	outputError('算法密钥不正确');
}
parse_str($decode, $data);
//验证商户密钥
if($appkey!=$data['appkey']){
	outputError('商户密钥不正确');
}

//开始充值
chongzhi($data);
function chongzhi($data) {
	//全局变量，函数内调用需要加global声明
	global $serverlist;
    try {
        //接收数据
        $account = $data['account'];
        $rmb = $data['money'];
        $sid = $data['quid'];
        $gold = $rmb * 400;
		//生成14位不重复的时间戳
		$orderid=createTimeStamp();
		//生成18位不重复的订单号
		//$orderid=generateOrderNumber();  
        /*----------------------游戏充值代码业务逻辑 start--------------------------------*/
		//后台充值接口
        $url = $serverlist[$sid]['url'] . '/yxzh_gm/gmcash_port/add_order?orderid=' . $orderid . '&userid=' . $account . '&ext=nor&rmb=' . $gold . '&game_platform=1&game_server=1';
        $res = file_get_contents($url);
        $res1 = json_decode($res, true);
        $res2 = $res1['msg'];
        if ($res2 == '1') {
            $host = "45.40.203.13"; //主机
            $port = "8888"; //端口
            $db_username = "root"; //你的数据库用户名
            $db_password = "root"; //你的数据库密码
            $conn = new mysqli($host, $db_username, $db_password, 'pay', $port);
            $rmbb = $rmb * 1; //获取整数，别去掉 会导致出现小数
            $result = mysqli_query($conn, "select * from pay where username = '" . $account . "' and server ='" . $serverlist[$sid]['name'] . "'");
            if ($result) {
                $rowdata = $result->fetch_object();
                if ($rowdata) {
                    $id = $rowdata->id;
                    mysqli_query($conn, "update pay set keyong=keyong+'" . $rmbb . "',pay=pay+'" . $rmbb . "' where id ='" . $id . "'");
                } else {
                    mysqli_query($conn, "insert into pay(username,server,pay,keyong) values('" . $account . "','" . $serverlist[$sid]['name'] . "','" . $rmbb . "','" . $rmbb . "')");
                }
            }
			outputSuccess('充值成功');
        } else {
			outputError('充值失败，错误信息：'.$res2);
            /*----------------------游戏充值代码业务逻辑 end----------------------------------*/
        }
    }
    catch(Exception $e) {
        outputError('充值异常，Error：'.$e->getMessage());
    }
}

/**
 * 生成14位不重复的时间戳
 * $length：随机数长度
 */
function createTimeStamp($length=4){
	//初始化变量为0
	$connt = 0;
	//建一个新数组
	$temp = array();
	while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
	}
	//为数组赋予新的键名
	shuffle($data);
	//数组转字符串
	$str=implode(",", $data);
	//替换掉逗号
	$number=str_replace(',', '', $str);
	return time().$number;
}
/**
 * 生成18位不重复的订单号
 * $length：随机数长度
 */
function generateOrderNumber($length=4){
	//14位的日期（年月日时分秒）
	$date=trim(date('Ymdhis ',time()));
	//初始化变量为0
	$connt = 0;
	//建一个新数组
	$temp = array();
	while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
	}
	//为数组赋予新的键名
	shuffle($data);
	//数组转字符串
	$str=implode(",", $data);
	//替换掉逗号
	$number=str_replace(',', '', $str);
	return $date.$number;
}


function outputError($msg){
	$arr=array('code'=>0,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

function outputSuccess($msg){
	$arr=array('code'=>1,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

/** 
 * 打印日志
 * $msg 日志内容
 */
function printLog($msg) {
	if (!is_dir('log')){
		mkdir('log',0777,true);
	}
	$path="log/".date('Y-m-d').".log";
	file_put_contents($path, "【" . date('Y-m-d H:i:s') . "】" . $msg . "\r\n\r\n", FILE_APPEND);
}
