<?php
/*
 * 元宝支付 https://www.18pay.net
 * Date: 2020/12/10
 * Time: 15:38
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究接口使用，只是提供一个参考，最终解释权归美奇软件开发工作室所有。
 * 严禁一切钓鱼、色情、赌博、私彩及违反国家法律法规等使用。
 * 注意：
 * UTF-8编码不要在记事本下编辑，否则会出现一些奇葩的问题，正确方法应在开发工具里打开编辑
 */
require 'config.php';
require "Des.php";

//下面代码基本不需要修改
if (empty($_POST)) $_POST = $_GET;  //如果为GET方式访问
if(version_compare(PHP_VERSION,'5.4.0','<')){
	outputError('PHP版本要求大于5.4.0');
}
if(!isset($_POST['appid'])){
	outputError('参数非法');
}
//验证商户号
if($_POST['appid']!=$appid){
	outputError('商户编号不正确');
}
if (!function_exists('openssl_encrypt')){
	outputError('请开启php.ini的openssl扩展');
}
//解密接口参数
$des = new Des();
$parameter=$_POST['parameter'];
$decode=$des->decrypt($parameter,$deskey);
if(empty($decode)){
	outputError('算法密钥不正确');
}
parse_str($decode, $data);
//验证商户密钥
if($appkey!=$data['appkey']){
	outputError('商户密钥不正确');
}

//开始充值
chongzhi($data);
function chongzhi($data){
	try{
		//游戏充值代码
		$account = $data['account'];
		$money   = $data['money'];
		$alias   = $data['alias'];
		$scale   = $data['scale'];
		$gold=$money*$scale;//元宝=充值金额*充值比例
		//分区ID
		if(isset($data['param']) && !empty($data['param'])){
			$quid = intval($data['param']);
		}else{
			$quid = intval($data['quid']);
		}
		//socket通信的端口号，可以查看gm后台目录里cmd.php文件的代码
		if($quid==1){
			$port=9101;
		}elseif($quid==2){
			$port=9102;
		}elseif($quid==3){
			$port=9103;
		}elseif($quid==4){
			$port=9104;
		}elseif($quid==5){
			$port=9105;
		}elseif($quid==6){
			$port=9106;
		}elseif($quid==7){
			$port=9107;
		}elseif($quid==8){
			$port=9108;	
		}elseif($quid==9){
			$port=9109;
		}elseif($quid==10){
			$port=9110;
		}
		$result=@messagetogame('chongzhi '.$account.' '.$gold,$port);
		if($result=='chongzhi done'){
			//成功后返回
			$text = $gold>=10000?($gold/10000).'万':$gold;
			$msg = sprintf("角色%s成功充值金额%s元，获得%s：%s个",$account,$money,$alias,$text);
			outputSuccess($msg);
		}else if(strpos($result,'cmd') !== false){	
			outputError('充值失败，角色不在线');			
	    }else{
			outputError("充值失败，Socket返回结果：".$result);
		}
	} catch (\Exception $e) {
		outputError('充值异常，Error：'.$e->getMessage());
	}
}

function messagetogame($info,$port){
	//全局变量，函数内调用需要加global声明
	global $key;
    $socket = @socket_create(AF_INET,SOCK_STREAM,SOL_TCP) or die;
    $result = @socket_connect($socket,'127.0.0.1',$port) or die;
    $in = md5($info.$key).$info."\n";
    @socket_write($socket,$in,strlen($in)) or die;
    $out = @trim(socket_read($socket,1024));
    @socket_close($socket);
    return $out;
}

function outputError($msg){
	$arr=array('code'=>0,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

function outputSuccess($msg){
	$arr=array('code'=>1,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

/** 
 * 打印日志
 * $msg 日志内容
 */
function printLog($msg) {
	if (!is_dir('log')){
		mkdir('log',0777,true);
	}
	$path="log/".date('Y-m-d').".log";
	file_put_contents($path, "【" . date('Y-m-d H:i:s') . "】" . $msg . "\r\n\r\n", FILE_APPEND);
}