<%@ page language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ page import="java.net.*"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%!
/**
 * 元宝支付 https://18pay.net/
 * 详细：公用函数核心处理文件
 * 版本：1.0
 * 日期：2020-01-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
 */

    /**
	 * 写日志，方便测试（看网站需求，也可以改成把记录存入数据库）
	 * @param msg 要写入日志里的文本内容
	 */
	public void logResult(String msg){
		SimpleDateFormat sdf =  new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
		File log = new File(getServletContext().getRealPath("/")+"log.txt");
		if (!log.exists())//如果文件不存在,则新建
         {
            File parentDir = new File(log.getParent());
            if (!parentDir.exists())//如果所在目录不存在,则新建
            {
                parentDir.mkdirs();
            }
            try {
				log.createNewFile();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }
		//先创建一个writer对象
		Writer writer=null;
		BufferedWriter bw=null;
		try {
			writer=new FileWriter(log,true); //是否覆盖,true表示在末尾添加，false表示覆盖
			bw=new BufferedWriter(writer);
			//开始写入
			bw.write(sdf.format(new Date())+" "+msg+"\r\n");
			//写入大量数据，要刷新缓存区
			bw.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				//先开后关
				if (bw!=null) {
					bw.close();
				}
				if (writer!=null) {
					writer.close();
				}		 
			} catch (IOException e) {   
				e.printStackTrace();
			}
		}
	}
	public String httpGet(String urlStr) {
		HttpURLConnection conn = null;
		StringBuffer result = new StringBuffer();
		try {
			URL url = new URL(urlStr);
			conn = (HttpURLConnection) url.openConnection();
		    // 设置连接超时时间（10秒）
			conn.setConnectTimeout(10 * 1000);
			conn.setReadTimeout(10 * 1000);
			// 允许往流中写入数据，以流的形式进行连接
			conn.setDoOutput(true);
			conn.setDoInput(true);
			// 设置缓存
			conn.setUseCaches(false);
			// 是否执行http重定向
			conn.setInstanceFollowRedirects(true);
			// 设置使用标准编码格式编码参数的名（键值对）
			conn.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
			// 开始连接
			conn.connect();
			if (conn.getResponseCode() == 200) {// 连接成功的状态码
				BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
				String line = null;
				while ((line = reader.readLine()) != null) {
					result.append(line);
				}
				reader.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (conn != null) {
				// 解除连接，释放网络资源
				conn.disconnect();
			}
		}
		return result.toString();
	}
	
	public String httpPost(String urlStr, Map<String,String> params) {
		HttpURLConnection conn = null;
		StringBuffer result = new StringBuffer();
		try {
			URL url = new URL(urlStr);
			conn = (HttpURLConnection) url.openConnection();
			// 设置post请求方式
			conn.setRequestMethod("POST");
			// 设置连接超时时间（10秒）
			conn.setConnectTimeout(10 * 1000);
			conn.setReadTimeout(10 * 1000);
			// 允许往流中写入数据，以流的形式进行连接
			conn.setDoOutput(true);
			conn.setDoInput(true);
			// 设置缓存
			conn.setUseCaches(false);
			// 是否执行http重定向
			conn.setInstanceFollowRedirects(true);
			// 设置使用标准编码格式编码参数的名（键值对）
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			// allowUserInteraction 如果为 true，则在允许用户交互（例如弹出一个验证对话框）的上下文中对此 URL 进行检查。
            conn.setAllowUserInteraction(false);
			// 开始连接
			conn.connect();
			StringBuilder paramsBuilder = new StringBuilder();
			if (params != null && !params.isEmpty()) {
				for (java.util.Map.Entry<String,String> entry : params.entrySet()) {
                    paramsBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode((String) entry.getValue(), "UTF-8")).append("&");
                }
				paramsBuilder.deleteCharAt(paramsBuilder.length() - 1);// 去掉最后一个“&”
			}
			byte[] data = paramsBuilder.toString().getBytes();
			DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
			dos.write(data);
			dos.flush();
			dos.close();
			if (conn.getResponseCode() == 200) {// 连接成功的状态码
				BufferedReader reader=new BufferedReader(new InputStreamReader(conn.getInputStream(),"utf-8"));
				String line = null;
				while ((line = reader.readLine()) != null) {
					result.append(line);
				}
				reader.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (conn != null) {
				// 解除连接，释放网络资源
				conn.disconnect();
			}
		}
		return result.toString();
	}
    /**
	 * 建立跳转请求表单
	 */
	public String buildRequestForm(String url, Map<String,String> params) {
		StringBuffer html = new StringBuffer();
		html.append("<form id='requestForm' name='requestForm' action='" + url + "' method='post'>");
		for (java.util.Map.Entry<String,String> entry : params.entrySet()) { 
			html.append("<input type='hidden' name='" + entry.getKey() + "' value='" + entry.getValue()+ "' />");			
		}
		html.append("<input type='submit' value='确定' style='display:none;'></form>");
		html.append("<script>document.forms['requestForm'].submit();</script>");
		return html.toString();
	}
    /**
	 * ASCII码字典序
	 * @param map
	 * @return
	 */
	public String ASCII(Map<String, String> params) {
		List<String> keys = new ArrayList<String>(params.keySet()); //转为数组
	  	Collections.sort(keys); //重新排序
	  	StringBuilder prestr = new StringBuilder();
	  	for (int i = 0; i < keys.size(); i++) { //遍历拼接url 拼接成a=1&b=2
            String key = keys.get(i);
            String value = params.get(key);
	    	if(key== null||key.equals("")||key.equals("sign")||value== null||value.equals("")){
	    		continue; //跳过这些 不签名
	    	}
			// 第一个字符串签名不加& 其他加&连接起来参数
	    	if (!prestr.toString().equals("")) {
	    		prestr.append("&"); 
	    	}
	    	prestr.append(key + "=" + value);
        }
	  	return prestr.toString();
	}
%>