<%@ page language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@ page import="java.util.*"%>
<%@ include file="lib/pay_notify.jsp"%>
<%
 /**
 * 元宝支付 https://18pay.net/
 * 功能：异步通知页面
 * 版本：1.0
 * 日期：2020-01-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
 */

/**
 ***********************************************页面功能说明**********************************************
 * 创建该页面文件时，请留心该页面文件中无任何HTML代码及空格。
 * 该页面不能在本机电脑测试，请到服务器上做测试。请确保外部可以访问该页面。
 * 该页面可以使用Java开发工具调试，也可以使用Log日志调试
 * 调用日志示例：
   //引入Log类，位于：lib/Log.jsp
   Log log=new Log()
   log.info("日志内容");
 *********************************************************************************************************
 */

/**
 * 设置编码（放在jsp页面最顶部）
 */
request.setCharacterEncoding("utf-8");
response.setCharacterEncoding("utf-8");
response.setContentType("text/html;charset=UTF-8");

//申明hashMap变量储存接收到的参数名用于排序
Map<String,String> params = new HashMap<String,String>(); 
//获取请求的全部参数
Map requestParams = request.getParameterMap(); 
for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
	String key = (String) iter.next();
	String[] values = (String[]) requestParams.get(key);
	String valueStr = values[0];
	//乱码解决，这段代码在出现乱码时使用。如果sign不相等也可以使用这段代码转化
	//valueStr = new String(valueStr.getBytes("utf-8"), "gbk");
	params.put(key, valueStr);//增加到params保存
}
//计算得出通知验证结果
PayNotify payNotify = new PayNotify();
boolean verifyResult = payNotify.verify(params);
if(verifyResult) {//验证成功
	////////////////////////////请根据您的业务逻辑来编写程序（以下代码仅作参考）////////////////////////////////
	
    //获取接口的通知返回参数（可参考技术文档中服务器异步通知参数列表）	
	String pay_id    = request.getParameter("pay_id");                       //需要充值的ID或订单号或用户名
	double pay_money = Double.parseDouble(request.getParameter("pay_money"));//实际付款金额
	String pay_no    = request.getParameter("pay_no");                       //交易流水号
	String pay_time  = request.getParameter("pay_time");                     //付款的时间戳
	Integer pay_type  = Integer.parseInt(request.getParameter("pay_type"));  //支付方式1：支付宝 2：微信支付 3：QQ钱包
	String param     = (request.getParameter("param")!=null)?request.getParameter("param"):""; //自定义参数
	if(pay_no!=null&pay_no.length()!=0){//合法的数据	
		/*
		 * 在这里执行您网站的业务逻辑
		 * 提示：
		 * 1.判断该笔订单是否在商户网站中已经做过处理
		 * 2.如果没有做过处理，根据订单号（pay_id）在商户网站的订单系统中查到该笔订单的详细，并执行商户的业务程序
		 * 3.如果有做过处理，不执行商户的业务程序
		 * 4.注意：付款完成后，支付平台系统发送该交易状态通知
		*/
		out.write("success"); //请不要修改或删除，成功后必须返回success或ok给支付平台系统，否则会重复通知。
    }	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
}else{
	out.write("fail");//验证失败，返回fail，支付平台系统会重新通知
	//如要调试，请看lib/pay_notify.jsp页面的verify函数
}
%>