﻿<?php
/**
 * 元宝支付 https://18pay.net/
 * 功能：通知处理类
 * 详细：处理好接口通知返回
 * 版本：1.0
 * 日期：2020-01-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
 */

require_once("pay_core.function.php");
require_once("pay_md5.function.php");

class PayNotify {

	var $pay_config;

	function __construct($pay_config){
		$this->pay_config = $pay_config;
	}
    function PayNotify($pay_config) {
    	$this->__construct($pay_config);
    }
    /**
     * 针对notify_url验证消息是否是支付平台发出的合法消息
     * @return 验证结果
     */
	function verify(){
		if(empty($_POST)) {//判断POST来的数组是否为空
			return false;
		}
		else {
			//生成签名结果
			$isSign = $this->getSignVeryfy($_POST, $_POST["sign"]);
			//验证
			//isSign的结果不是true，与安全校验码、请求时的参数格式（如：带自定义参数等）、编码格式有关
			if ($isSign) {
				return true;
			} else {
				return false;
			}
		}
	}
	
    /**
     * 获取返回时的签名验证结果
     * @param $para_temp 通知返回来的参数数组
     * @param $sign 返回的签名结果
     * @return 签名验证结果
     */
	function getSignVeryfy($para_temp, $sign) {
		//除去待签名参数数组中的空值和签名参数
		$para_filter = paraFilter($para_temp);
		
		//对待签名参数数组排序
		$para_sort = argSort($para_filter);
		
		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		$prestr = createLinkstring($para_sort);
		
		$isSgin = false;
		$isSgin = md5Verify($prestr, $sign, $this->pay_config['appkey']);
		
		return $isSgin;
	}
}
?>
