// index.js
// 获取应用实例
const app = getApp()
Page({
  data: {
    showWebview: true,
    apiurl: "https://18pay.net",
    openid: "",
    order_no: "",
    money: 0,
    tips: "正在拉起微信支付，请稍候！",
  },
  /**
     * 生命周期函数--监听页面加载
     */
    onLoad(options) {
        var that = this;
        //获取页面传递过来的参数
        if(!that.isEmpty(options.number)){
            that.setData({
                order_no: options.number
            });  
        }
        if(!that.isEmpty(options.money)){
            that.setData({
                money: options.money
            }); 
        }
        if(!that.isEmpty(that.data.order_no)){
            that.login();
        }
    },
    login() {
        var that = this;
        wx.login({
            success: function(res) {
              if (res.code) {
                //console.log("微信登录凭证："+res.code);
                wx.request({
                    url: that.data.apiurl+"/Index/Weixin/getopenid.html",
                    method: 'POST',
                    dataType: 'json',
                    data: {
                        'appid':wx.getAccountInfoSync().miniProgram.appId,//当前小程序APPid
                        'code': res.code
                    },
                    success(res) {
                        if(res.data.code==1){
                            //console.log("获取到的openid："+res.data.openid);
                            that.setData({
                                openid: res.data.openid,
                                showWebview: false
                            });
                            that.onPay();
                        }
                    }
                });
              } else {
                //console.log('用户登录失败' + res.errMsg)
              }
            }
        }) 
    },
    onPay() {
        var that = this;
        if(that.isEmpty(that.data.openid)){
			return;
        }
        if(that.isEmpty(that.data.order_no)){
			return;
        }
        //console.log("openid："+that.data.openid);
        //console.log("订单编号："+that.data.order_no);
        /*----------------------向元宝支付平台发起支付请求--------------------*/
        wx.request({
            url: that.data.apiurl+"/Index/Weixin/wxapp.html",
            method: 'POST',
            dataType: 'json',
            data: {
                openid: that.data.openid,
                number: that.data.order_no
            },
            success(res) {
                //success回调的res已经是解析好的json对象，无需再次JSON.parse，二次parse导致的错误产生
                let result = res.data;              
                //小程序拉起支付
                if(result.code == 1){      
                    wx.requestPayment({
                        'timeStamp': result.payinfo.timeStamp,
                        'nonceStr': result.payinfo.nonceStr,
                        'package': result.payinfo.package,
                        'signType': result.payinfo.signType,
                        'paySign': result.payinfo.paySign,
                        'success': function(res) {
                            that.setData({
                                tips: "支付成功",
                                showWebview: true
                            });
                        },
                        'fail': function(res) {
                            that.setData({
                                tips: "支付失败，请重新提交支付订单！",
                                showWebview: true
                            });
                        },
                        'complete': function(res) {
                            that.setData({
                                tips: "支付完成",
                                showWebview: true
                            });
                        }
                    })
                }else{
                    wx.showModal({
                        title: '',
                        content: result.msg,
                        confirmText: '好的',
                        showCancel: false,
                        success(result) {
                            //如果用户点击了确定按钮
                            if(result.confirm) {
                                that.setData({
                                    showWebview: true,
                                    order_no: "",
                                    money:0
                                }); 
                            }
                        }
                    })
                }
            }
        })             
        /*----------------------向元宝支付平台发起支付请求--------------------*/
    },
    isEmpty(content){
        if(content==null || typeof(content)=="undefined" || content=="") {
            return true;
        }else{
            return false;
        }
    },
})
